/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.AbstractFilePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FalsePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.TruePredicate;

class OrPredicate
extends AbstractFilePredicate {
    private final Collection<FilePredicate> predicates = new ArrayList<FilePredicate>();

    private OrPredicate() {
    }

    public static FilePredicate create(Collection<FilePredicate> predicates) {
        if (predicates.isEmpty()) {
            return TruePredicate.TRUE;
        }
        OrPredicate result = new OrPredicate();
        for (FilePredicate filePredicate : predicates) {
            if (filePredicate == TruePredicate.TRUE) {
                return TruePredicate.TRUE;
            }
            if (filePredicate == FalsePredicate.FALSE) continue;
            if (filePredicate instanceof OrPredicate) {
                result.predicates.addAll(((OrPredicate)filePredicate).predicates);
                continue;
            }
            result.predicates.add(filePredicate);
        }
        return result;
    }

    @Override
    public boolean apply(InputFile f) {
        for (FilePredicate predicate : this.predicates) {
            if (!predicate.apply(f)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    Collection<FilePredicate> predicates() {
        return this.predicates;
    }
}

